#include "common_header.h"
#include "vertexBufferObject.h"

CVertexBufferObject::CVertexBufferObject()
{
	VBO = 0;
	Data = NULL;
	DataSize = 0;
}

CVertexBufferObject::~CVertexBufferObject()
{
}

CVertexBufferObject::operator GLuint ()
{
	return VBO;
}

void CVertexBufferObject::Init()
{
	glGenBuffers(1, &VBO);
}

void CVertexBufferObject::AddData(void *NewData, int NewDataSize)
{
	BYTE *OldData = Data;
	int OldDataSize = DataSize;

	DataSize += NewDataSize;

	Data = new BYTE[DataSize];

	for(int i = 0; i < OldDataSize; i++)
	{
		Data[i] = OldData[i];
	}

	for(int i = 0; i < NewDataSize; i++)
	{
		Data[OldDataSize + i] = ((BYTE*)NewData)[i];
	}

	delete [] OldData;
}

void CVertexBufferObject::UploadDataToGPU(GLenum Usage)
{
	glBindBuffer(GL_ARRAY_BUFFER, VBO);
	glBufferData(GL_ARRAY_BUFFER, DataSize, Data, Usage);
	glBindBuffer(GL_ARRAY_BUFFER, 0);

	delete [] Data;
	Data = NULL;
	DataSize = 0;
}

void CVertexBufferObject::Destroy()
{
	glDeleteBuffers(1, &VBO);
}
